/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateNormalEstimator;
import weka.estimators.UnivariateQuantileEstimator;

public class UnivariateKernelEstimator
implements UnivariateDensityEstimator,
UnivariateIntervalEstimator,
UnivariateQuantileEstimator {
    protected TreeMap<Double, Double> m_TM = new TreeMap();
    protected double m_WeightedSum = 0.0;
    protected double m_WeightedSumSquared = 0.0;
    protected double m_SumOfWeights = 0.0;
    protected double m_Width = Double.MAX_VALUE;
    protected double m_Exponent = -0.25;
    protected double m_MinWidth = 1.0E-6;
    public static final double CONST = -0.5 * Math.log(Math.PI * 2);
    protected double m_Threshold = 1.0E-6;
    protected int m_NumIntervals = 1000;

    @Override
    public void addValue(double value, double weight) {
        this.m_WeightedSum += value * weight;
        this.m_WeightedSumSquared += value * value * weight;
        this.m_SumOfWeights += weight;
        if (this.m_TM.get(value) == null) {
            this.m_TM.put(value, weight);
        } else {
            this.m_TM.put(value, this.m_TM.get(value) + weight);
        }
    }

    public void updateWidth() {
        if (this.m_SumOfWeights > 0.0) {
            double mean = this.m_WeightedSum / this.m_SumOfWeights;
            double variance = this.m_WeightedSumSquared / this.m_SumOfWeights - mean * mean;
            if (variance < 0.0) {
                variance = 0.0;
            }
            this.m_Width = Math.sqrt(variance) * Math.pow(this.m_SumOfWeights, this.m_Exponent);
            if (this.m_Width <= this.m_MinWidth) {
                this.m_Width = this.m_MinWidth;
            }
        } else {
            this.m_Width = Double.MAX_VALUE;
        }
    }

    @Override
    public double[][] predictIntervals(double conf) {
        this.updateWidth();
        double val = Statistics.normalInverse(1.0 - (1.0 - conf) / 2.0);
        double min = this.m_TM.firstKey() - val * this.m_Width;
        double max = this.m_TM.lastKey() + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double[] probabilities = new double[this.m_NumIntervals];
        double leftVal = Math.exp(this.logDensity(min));
        int i = 0;
        while (i < this.m_NumIntervals) {
            double rightVal = Math.exp(this.logDensity(min + (double)(i + 1) * delta));
            probabilities[i] = 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
            ++i;
        }
        int[] sortedIndices = Utils.sort(probabilities);
        double sum = 0.0;
        boolean[] toUse = new boolean[probabilities.length];
        int k = 0;
        while (sum < conf && k < toUse.length) {
            toUse[sortedIndices[toUse.length - (k + 1)]] = true;
            sum += probabilities[sortedIndices[toUse.length - (k + 1)]];
            ++k;
        }
        probabilities = null;
        ArrayList<double[]> intervals = new ArrayList<double[]>();
        double[] interval = null;
        boolean haveStartedInterval = false;
        int i2 = 0;
        while (i2 < this.m_NumIntervals) {
            if (toUse[i2]) {
                if (!haveStartedInterval) {
                    haveStartedInterval = true;
                    interval = new double[]{min + (double)i2 * delta, min + (double)(i2 + 1) * delta};
                }
            } else if (haveStartedInterval) {
                haveStartedInterval = false;
                intervals.add(interval);
            }
            ++i2;
        }
        if (haveStartedInterval) {
            intervals.add(interval);
        }
        return (double[][])intervals.toArray((T[])new double[0][0]);
    }

    @Override
    public double predictQuantile(double percentage) {
        this.updateWidth();
        double val = Statistics.normalInverse(0.975);
        double min = this.m_TM.firstKey() - val * this.m_Width;
        double max = this.m_TM.lastKey() + val * this.m_Width;
        double delta = (max - min) / (double)this.m_NumIntervals;
        double[] probabilities = new double[this.m_NumIntervals];
        double sum = 0.0;
        double leftVal = Math.exp(this.logDensity(min));
        int i = 0;
        while (i < this.m_NumIntervals) {
            if (sum >= percentage) {
                return min + (double)i * delta;
            }
            double rightVal = Math.exp(this.logDensity(min + (double)(i + 1) * delta));
            sum += 0.5 * (leftVal + rightVal) * delta;
            leftVal = rightVal;
            ++i;
        }
        return max;
    }

    protected double logOfSum(double logOfX, double logOfY) {
        if (Double.isNaN(logOfX)) {
            return logOfY;
        }
        if (Double.isNaN(logOfY)) {
            return logOfX;
        }
        if (logOfX > logOfY) {
            return logOfX + Math.log(1.0 + Math.exp(logOfY - logOfX));
        }
        return logOfY + Math.log(1.0 + Math.exp(logOfX - logOfY));
    }

    protected void runningSum(Set<Map.Entry<Double, Double>> c, double value, double[] sums) {
        double offset = CONST - Math.log(this.m_Width);
        double logFactor = Math.log(this.m_Threshold) - Math.log(1.0 - this.m_Threshold);
        double logSumOfWeights = Math.log(this.m_SumOfWeights);
        for (Map.Entry<Double, Double> entry : c) {
            if (!(entry.getValue() > 0.0)) continue;
            double diff = (entry.getKey() - value) / this.m_Width;
            double logDensity = offset - 0.5 * diff * diff;
            double logWeight = Math.log(entry.getValue());
            sums[0] = this.logOfSum(sums[0], logWeight + logDensity);
            sums[1] = this.logOfSum(sums[1], logWeight);
            if (logDensity + logSumOfWeights < this.logOfSum(logFactor + sums[0], logDensity + sums[1])) break;
        }
    }

    @Override
    public double logDensity(double value) {
        this.updateWidth();
        double[] sums = new double[]{Double.NaN, Double.NaN};
        this.runningSum(this.m_TM.tailMap(value, true).entrySet(), value, sums);
        this.runningSum(this.m_TM.headMap(value, false).descendingMap().entrySet(), value, sums);
        return sums[0] - Math.log(this.m_SumOfWeights);
    }

    public String toString() {
        return "Kernel estimator with bandwidth " + this.m_Width + " and total weight " + this.m_SumOfWeights + " based on\n" + this.m_TM.toString();
    }

    public static void main(String[] args) {
        Random r = new Random();
        UnivariateKernelEstimator e = new UnivariateKernelEstimator();
        System.out.println(e);
        double sum = 0.0;
        int i = 0;
        while (i < 1000) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
            ++i;
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 1000.0);
        i = 0;
        while (i < 1000) {
            e.addValue(0.1 * r.nextGaussian() - 3.0, 1.0);
            e.addValue(r.nextGaussian() * 0.25, 3.0);
            ++i;
        }
        sum = 0.0;
        int points = 10000;
        int i2 = 0;
        while (i2 < points) {
            double value = r.nextDouble() * 10.0 - 5.0;
            sum += Math.exp(e.logDensity(value));
            ++i2;
        }
        System.out.println("Approximate integral: " + 10.0 * sum / (double)points);
        double[][] Intervals = e.predictIntervals(0.9);
        System.out.println("Printing kernel intervals ---------------------");
        int k = 0;
        while (k < Intervals.length) {
            System.out.println("Left: " + Intervals[k][0] + "\t Right: " + Intervals[k][1]);
            ++k;
        }
        System.out.println("Finished kernel printing intervals ---------------------");
        double Covered = 0.0;
        int i3 = 0;
        while (i3 < 1000) {
            double val = -1.0;
            val = r.nextDouble() < 0.25 ? 0.1 * r.nextGaussian() - 3.0 : r.nextGaussian() * 0.25;
            int k2 = 0;
            while (k2 < Intervals.length) {
                if (val >= Intervals[k2][0] && val <= Intervals[k2][1]) {
                    Covered += 1.0;
                    break;
                }
                ++k2;
            }
            ++i3;
        }
        System.out.println("Coverage at 0.9 level for kernel intervals: " + Covered / 1000.0);
        UnivariateKernelEstimator eKernel = new UnivariateKernelEstimator();
        UnivariateNormalEstimator eNormal = new UnivariateNormalEstimator();
        int j = 1;
        while (j < 5) {
            int k3;
            double val;
            double numTrain = Math.pow(10.0, j);
            System.out.println("Number of training cases: " + numTrain);
            int i4 = 0;
            while ((double)i4 < numTrain) {
                double val2 = r.nextGaussian() * 1.5 + 0.5;
                eKernel.addValue(val2, 1.0);
                eNormal.addValue(val2, 1.0);
                ++i4;
            }
            sum = 0.0;
            points = 10000;
            i4 = 0;
            while (i4 < points) {
                double value = r.nextDouble() * 20.0 - 10.0;
                sum += Math.exp(eKernel.logDensity(value));
                ++i4;
            }
            System.out.println("Approximate integral for kernel estimator: " + 20.0 * sum / (double)points);
            double loglikelihoodKernel = 0.0;
            double loglikelihoodNormal = 0.0;
            int i5 = 0;
            while (i5 < 1000) {
                double val3 = r.nextGaussian() * 1.5 + 0.5;
                loglikelihoodKernel += eKernel.logDensity(val3);
                loglikelihoodNormal += eNormal.logDensity(val3);
                ++i5;
            }
            System.out.println("Loglikelihood for kernel estimator: " + loglikelihoodKernel / 1000.0);
            System.out.println("Loglikelihood for normal estimator: " + loglikelihoodNormal / 1000.0);
            double[][] kernelIntervals = eKernel.predictIntervals(0.95);
            double[][] normalIntervals = eNormal.predictIntervals(0.95);
            System.out.println("Printing kernel intervals ---------------------");
            int k4 = 0;
            while (k4 < kernelIntervals.length) {
                System.out.println("Left: " + kernelIntervals[k4][0] + "\t Right: " + kernelIntervals[k4][1]);
                ++k4;
            }
            System.out.println("Finished kernel printing intervals ---------------------");
            System.out.println("Printing normal intervals ---------------------");
            k4 = 0;
            while (k4 < normalIntervals.length) {
                System.out.println("Left: " + normalIntervals[k4][0] + "\t Right: " + normalIntervals[k4][1]);
                ++k4;
            }
            System.out.println("Finished normal printing intervals ---------------------");
            double kernelCovered = 0.0;
            double normalCovered = 0.0;
            int i6 = 0;
            while (i6 < 1000) {
                val = r.nextGaussian() * 1.5 + 0.5;
                k3 = 0;
                while (k3 < kernelIntervals.length) {
                    if (val >= kernelIntervals[k3][0] && val <= kernelIntervals[k3][1]) {
                        kernelCovered += 1.0;
                        break;
                    }
                    ++k3;
                }
                k3 = 0;
                while (k3 < normalIntervals.length) {
                    if (val >= normalIntervals[k3][0] && val <= normalIntervals[k3][1]) {
                        normalCovered += 1.0;
                        break;
                    }
                    ++k3;
                }
                ++i6;
            }
            System.out.println("Coverage at 0.95 level for kernel intervals: " + kernelCovered / 1000.0);
            System.out.println("Coverage at 0.95 level for normal intervals: " + normalCovered / 1000.0);
            kernelIntervals = eKernel.predictIntervals(0.8);
            normalIntervals = eNormal.predictIntervals(0.8);
            kernelCovered = 0.0;
            normalCovered = 0.0;
            i6 = 0;
            while (i6 < 1000) {
                val = r.nextGaussian() * 1.5 + 0.5;
                k3 = 0;
                while (k3 < kernelIntervals.length) {
                    if (val >= kernelIntervals[k3][0] && val <= kernelIntervals[k3][1]) {
                        kernelCovered += 1.0;
                        break;
                    }
                    ++k3;
                }
                k3 = 0;
                while (k3 < normalIntervals.length) {
                    if (val >= normalIntervals[k3][0] && val <= normalIntervals[k3][1]) {
                        normalCovered += 1.0;
                        break;
                    }
                    ++k3;
                }
                ++i6;
            }
            System.out.println("Coverage at 0.8 level for kernel intervals: " + kernelCovered / 1000.0);
            System.out.println("Coverage at 0.8 level for normal intervals: " + normalCovered / 1000.0);
            ++j;
        }
    }
}

